import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.TModelBag;
import org.uddi4j.util.TModelKey;
import java.util.Vector;

public class UDDIFindBusiness14 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
//		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setInquiryURL("http://uddi.ibm.com/ubr/inquiryapi");

		Vector tbv = new Vector();
//		TModelKey tk = new TModelKey("uuid:64c756d1-3374-4e00-ae83-ee12e38fae63");
		TModelKey tk = new TModelKey("uuid:ac104dcc-d623-452f-88a7-f8acd94d9b2b");
		tbv.addElement(tk);
//		tk = new TModelKey("uuid:4cd7e4bc-648b-426d-9936-443eaac8ae23");
		tk = new TModelKey("uuid:a2f36b65-2d66-4088-abc7-914d0e05eb9e");
		tbv.addElement(tk);
		TModelBag tb = new TModelBag();
		tb.setTModelKeyVector(tbv);

		Vector fqv = new Vector();
		FindQualifier fq = new FindQualifier(FindQualifier.sortByNameDesc);
		fqv.add(fq);
		FindQualifiers fqs = new FindQualifiers();
		fqs.setFindQualifierVector(fqv);

		BusinessList bl = proxy.find_business(null, null, null, null, tb, fqs, 0);

		BusinessInfos bis = bl.getBusinessInfos();
		if (bis.size() == 0) {
			System.out.println("no business(es) found");
			System.exit(0);
		}

		System.out.println(bis.size()+" business(es) found\n");
		Vector biv = bis.getBusinessInfoVector();
		for (int i = 0; i < biv.size(); i++) {
			BusinessInfo bi = (BusinessInfo)biv.elementAt(i);
			System.out.println(bi.getNameString());
			System.out.println(bi.getBusinessKey());
			System.out.println("\n");
		}
	}
}